/*
  
  Optical Covert Channel Demonstration       
                                                         
  Author: Joe Grand, Grand Idea Studio [@joegrand]             
  
  Program Description:
  
  This program uses an Arduino and external LED to create an optical covert channel.
  Optical covert channels transmit data by modulating visible light in a way that is
  undetectable to the human eye. ASCII printable data is sent via the LED using a
  standard UART interface (in this case, the SoftwareSerial library).

  More details about this example and the hardware needed to receive the data
  can be found at: 
  http://www.grandideastudio.com/portfolio/optical-covert-channels/

  Revisions:
  
  1.0 (January 31, 2018): Initial release
  
*/

#include <SoftwareSerial.h>

#define txPin    11  // Serial output (connects to the external LED 
                     // through a current-limiting resistor)
#define rxPin    10  // Serial input (unused, but required by the library)
#define ledPin   13  // Most Arduino boards have an on-board LED on this pin

// Set up a new serial port
SoftwareSerial opticSerial =  SoftwareSerial(rxPin, txPin);

char const msg_covert[] = {"I'm Arduino speaking through light waves!\n"};

void setup()  // Setup code (called once on start-up)
{
  // Define pin modes
  pinMode(rxPin, INPUT);
  pinMode(txPin, OUTPUT);
  pinMode(ledPin, OUTPUT);

  digitalWrite(ledPin, LOW);  // Turn LED off since we're not using it

  // Setup Arduino Serial Monitor
  Serial.begin(9600);
  while (!Serial);        // Wait until ready
  Serial.println("\n\nOptical Covert Channel Demonstration");
  
  // Setup Optical Covert Channel Serial Port
  opticSerial.begin(19200);
  while (!opticSerial);   // Wait until ready
  
  Serial.print("Exfiltrating data via LED: ");
  Serial.println(msg_covert);
  Serial.flush();     // Wait for all bytes to be transmitted
}

void loop()  // Main code (runs repeatedly)
{
      opticSerial.print(msg_covert); // Transmit secret message through the LED
      opticSerial.flush();           // Wait for all bytes to be transmitted
      
      //Serial.print("+");  // Display progress indicator on Serial Monitor (for testing)
      //Serial.flush();     // Wait for byte to be transmitted

      delay(2);           // Delay to let receiver properly synchronize
}



