//
// Description:  Controls Nichia multi-color LED for the Lichtenberg Lightning base
//
// This file contains code for the Microchip PIC12C508
//
// version 1.0 released 5/22/99
//
// oscillator = LP (32.768kHz)
// WDT = off
// code protect = off
// master clear = internal
//
// Copyright (c) 1999 Joe Grand, jgrand@mindspring.com
//

#include <pic.h>

// color defines
// GP0 = red
// GP1 = green
// GP2 = blue

#define WHITE   0b00000000
#define AQUA    0b00000001
#define PURPLE  0b00000010
#define BLUE    0b00000011
#define YELLOW  0b00000100
#define GREEN   0b00000101
#define RED     0b00000110
#define NONE    0b00000111

unsigned char   counter_ms;     // incremented every 488.281ms

void main(void)
{
    // port pin setup
    TRIS = 0x00;    // Configure port to outputs
    GPIO = WHITE;   // Default
	
	// timer setup
	TMR0 = 0;
	OPTION = 0b11000011; // tmr0 enable with 1:16 prescaler
	counter_ms = 0;
	
    while(1)
    {
        if (TMR0 == 250) // 488.281mS tmr0 (1:16 prescaler * 250)
        {   
            TMR0 = 0;
            ++counter_ms;
            
            if (counter_ms == 123) // 1 minute has elapsed
            {
                counter_ms = 0;
                        
                switch(GPIO) // change color
                {
                    case WHITE:
                        GPIO = GREEN;
                        break;
                    case GREEN:
                        GPIO = BLUE;
                        break;
                    case BLUE:
                        GPIO = YELLOW;
                        break;
                    case YELLOW:
                        GPIO = RED;
                        break;
                    case RED:
                        GPIO = AQUA;
                        break;
                    case AQUA:
                        GPIO = PURPLE;
                        break;
                    case PURPLE:
                        GPIO = WHITE;
                        break;
                }
            }
        }
    }
}
